function ShowInt(handles)
% Plots the integrated intensitiesover the energies as a 2D map.
% Adjusts to the user selected ROI.

%% Get Handles
Axis       = get(handles.Load,'UserData');
modus      = get(handles.DecEELS,'UserData');
Zoom       = get(handles.Zoom,'UserData');

%% Load Files
if modus==0
    image  = load(fullfile(tempdir,'ShowOrg.mat')).image;
    Intensity  = sum(image,3);
else
    Intensity  = get(handles.ShowInt,'UserData');
end

%% Calculate

Intensity = Intensity(Zoom(2):Zoom(4),Zoom(1):Zoom(3),:);
ScaleY    = Axis(1);
ScaleX    = Axis(2);
XMax      = ScaleX*size(Intensity,2)/2;
YMax      = ScaleY*size(Intensity,1)/2;
AxisX     = linspace(-XMax,XMax,size(Intensity,2));
AxisY     = linspace(YMax,-YMax,size(Intensity,1));
%% Create Images
figure;
imagesc(AxisX,AxisY,Intensity);
colormap(hot(255));
colorbar;
xlabel( 'x (nm)' );
ylabel( 'y (nm)' );
title('Intensity Map');
axis equal
set(gca,'FontSize',16);
set(gca,'YDir','normal')
hold off

clearvars all
end